<?php
/**
 * WARNING: Do not edit by hand, this file was generated by Crank:
 *
 * https://github.com/gocardless/crank
 */

namespace GoCardlessPro\Services;

use \GoCardlessPro\Core\Paginator;
use \GoCardlessPro\Core\Util;
use \GoCardlessPro\Core\ListResponse;
use \GoCardlessPro\Resources\MandateImport;
use \GoCardlessPro\Core\Exception\InvalidStateException;


/**
 * Service that provides access to the MandateImport
 * endpoints of the API
 */
class MandateImportsService extends BaseService
{

    protected $envelope_key   = 'mandate_imports';
    protected $resource_class = '\GoCardlessPro\Resources\MandateImport';


    /**
    * Create a new mandate import
    *
    * Example URL: /mandate_imports
    *
    * @param  string[mixed] $params An associative array for any params
    * @return MandateImport
    **/
    public function create($params = array())
    {
        $path = "/mandate_imports";
        if(isset($params['params'])) { 
            $params['body'] = json_encode(array($this->envelope_key => (object)$params['params']));
        
            unset($params['params']);
        }

        
        try {
            $response = $this->api_client->post($path, $params);
        } catch(InvalidStateException $e) {
            if ($e->isIdempotentCreationConflict()) {
                return $this->get($e->getConflictingResourceId());
            }

            throw $e;
        }
        

        return $this->getResourceForResponse($response);
    }

    /**
    * Get a mandate import
    *
    * Example URL: /mandate_imports/:identity
    *
    * @param  string        $identity Unique identifier, beginning with "IM".
    * @param  string[mixed] $params   An associative array for any params
    * @return MandateImport
    **/
    public function get($identity, $params = array())
    {
        $path = Util::subUrl(
            '/mandate_imports/:identity',
            array(
                
                'identity' => $identity
            )
        );
        if(isset($params['params'])) { $params['query'] = $params['params'];
            unset($params['params']);
        }

        
        $response = $this->api_client->get($path, $params);
        

        return $this->getResourceForResponse($response);
    }

    /**
    * Submit a mandate import
    *
    * Example URL: /mandate_imports/:identity/actions/submit
    *
    * @param  string        $identity Unique identifier, beginning with "IM".
    * @param  string[mixed] $params   An associative array for any params
    * @return MandateImport
    **/
    public function submit($identity, $params = array())
    {
        $path = Util::subUrl(
            '/mandate_imports/:identity/actions/submit',
            array(
                
                'identity' => $identity
            )
        );
        if(isset($params['params'])) { 
            $params['body'] = json_encode(array("data" => (object)$params['params']));
        
            unset($params['params']);
        }

        
        try {
            $response = $this->api_client->post($path, $params);
        } catch(InvalidStateException $e) {
            if ($e->isIdempotentCreationConflict()) {
                return $this->get($e->getConflictingResourceId());
            }

            throw $e;
        }
        

        return $this->getResourceForResponse($response);
    }

    /**
    * Cancel a mandate import
    *
    * Example URL: /mandate_imports/:identity/actions/cancel
    *
    * @param  string        $identity Unique identifier, beginning with "IM".
    * @param  string[mixed] $params   An associative array for any params
    * @return MandateImport
    **/
    public function cancel($identity, $params = array())
    {
        $path = Util::subUrl(
            '/mandate_imports/:identity/actions/cancel',
            array(
                
                'identity' => $identity
            )
        );
        if(isset($params['params'])) { 
            $params['body'] = json_encode(array("data" => (object)$params['params']));
        
            unset($params['params']);
        }

        
        try {
            $response = $this->api_client->post($path, $params);
        } catch(InvalidStateException $e) {
            if ($e->isIdempotentCreationConflict()) {
                return $this->get($e->getConflictingResourceId());
            }

            throw $e;
        }
        

        return $this->getResourceForResponse($response);
    }

}
