<?php
/**
 * Admin Clients
 *
 * @package blesta
 * @subpackage blesta.language.fr_fr
 * @copyright Copyright (c) 2024, Phillips Data, Inc.
 * @license http://www.blesta.com/license/ The Blesta License Agreement
 * @link http://www.blesta.com/ Blesta
 */

$lang['AdminClients.!success.note_added'] = 'La note a été créée avec succès.';
$lang['AdminClients.!success.note_updated'] = 'La note a été mise à jour avec succès.';
$lang['AdminClients.!success.note_deleted'] = 'La note a été supprimée avec succès.';
$lang['AdminClients.!success.client_added'] = 'Le client a été créé avec succès.';
$lang['AdminClients.!success.client_updated'] = 'Le client a été mis à jour avec succès.';
$lang['AdminClients.!success.client_deleted'] = 'Le client a été supprimé avec succès.';
$lang['AdminClients.!success.contact_added'] = 'Le contact a été créé avec succès.';
$lang['AdminClients.!success.contact_updated'] = 'Le contact a été mis à jour avec succès.';
$lang['AdminClients.!success.invoice_added'] = 'La facture #%1$s a été créée avec succès.';
$lang['AdminClients.!success.invoice_updated'] = 'La facture #%1$s a été mise à jour avec succès.';
$lang['AdminClients.!success.draftinvoice_added'] = 'Le projet de facture #%1$s a été créé avec succès.';
$lang['AdminClients.!success.draftinvoice_updated'] = 'Le projet de facture #%1$s a été mis à jour avec succès.';
$lang['AdminClients.!success.draftinvoice_created'] = 'Le projet de facture #%1$s a été créé avec succès en tant que facture #%2$s.';
$lang['AdminClients.!success.quotation_added'] = 'La citation #%1$s a été créée avec succès.';
$lang['AdminClients.!success.quotation_updated'] = 'Le devis #%1$s a été mis à jour avec succès.';
$lang['AdminClients.!success.draftquotation_added'] = 'Le projet de devis #%1$s a été créé avec succès.';
$lang['AdminClients.!success.draftquotation_updated'] = 'Le projet de devis #%1$s a été mis à jour avec succès.';
$lang['AdminClients.!success.approvequotation_approved'] = 'Le devis #%1$s a été approuvé avec succès.';
$lang['AdminClients.!success.invoicequotation_invoiced'] = 'Le devis #%1$s a été facturé avec succès en tant que facture #%2$s.';
$lang['AdminClients.!success.addccaccount_added'] = 'Le compte de carte de crédit a été créé avec succès.';
$lang['AdminClients.!success.editccaccount_updated'] = 'Le compte de la carte de crédit a été modifié avec succès.';
$lang['AdminClients.!success.addachaccount_added'] = 'Le compte ACH a été créé avec succès.';
$lang['AdminClients.!success.editachaccount_updated'] = 'Le compte ACH a été modifié avec succès.';
$lang['AdminClients.!success.deleteccaccount_deleted'] = 'Le compte de paiement a été supprimé avec succès.';
$lang['AdminClients.!success.deleteachaccount_deleted'] = 'Le compte de paiement a été supprimé avec succès.';
$lang['AdminClients.!success.verifyachaccount_verified'] = 'Le compte de paiement a été vérifié avec succès.';
$lang['AdminClients.!success.accounts_updated'] = 'Le compte de paiement à utiliser pour le débit automatique a été mis à jour.';
$lang['AdminClients.!success.accounts_deleted'] = 'Le compte de paiement à utiliser pour le débit automatique a été supprimé.';
$lang['AdminClients.!success.accounttypes_updated'] = 'Les paramètres du type de paiement accepté ont été mis à jour avec succès !';
$lang['AdminClients.!success.recurinvoice_deleted'] = 'La facture périodique a été supprimée avec succès.';
$lang['AdminClients.!success.recurinvoice_updated'] = 'La facture périodique a été mise à jour avec succès.';
$lang['AdminClients.!success.edittransaction_updated'] = 'La transaction a été mise à jour avec succès.';
$lang['AdminClients.!success.transaction_unapplied'] = 'La transaction a été supprimée avec succès de la facture.';
$lang['AdminClients.!success.invoices_queued'] = 'Les factures sélectionnées ont été mises en file d\'attente pour livraison.';
$lang['AdminClients.!success.invoices_delivered'] = 'Les factures sélectionnées ont été livrées avec succès.';
$lang['AdminClients.!success.invoices_voided'] = 'Les factures suivantes ont été annulées avec succès : %1$s.';
$lang['AdminClients.!success.quotations_delivered'] = 'Les devis sélectionnés ont été livrés avec succès.';
$lang['AdminClients.!success.quotations_status_updated'] = 'Les devis suivants ont été mis à jour avec succès : %1$s.';
$lang['AdminClients.!success.makepayment_processed'] = 'Le paiement a été traité avec succès pour %1$s. Numéro de transaction : %2$s';
$lang['AdminClients.!success.recordpayment_processed'] = 'Le paiement a été enregistré avec succès pour %1$s.';
$lang['AdminClients.!success.recordpayment_credits'] = 'Les crédits ont été enregistrés avec succès.';
$lang['AdminClients.!success.deletedraftinvoice_deleted'] = 'Le projet de facture a été supprimé avec succès !';
$lang['AdminClients.!success.email_sent'] = 'Le courriel a été envoyé avec succès.';
$lang['AdminClients.!success.contact_deleted'] = 'Le contact %1$s %2$s a été supprimé avec succès !';
$lang['AdminClients.!success.service_added'] = 'Le service a été ajouté avec succès.';
$lang['AdminClients.!success.service_edited'] = 'Le service a été mis à jour avec succès.';
$lang['AdminClients.!success.service_deleted'] = 'Le service a été supprimé avec succès.';
$lang['AdminClients.!success.packages_restricted'] = 'L\'accès restreint aux colis a été mis à jour pour ce client.';
$lang['AdminClients.!success.service_tab'] = 'Les données ont été mises à jour avec succès.';
$lang['AdminClients.!success.services_scheduled_cancel'] = 'Les services sélectionnés ont été programmés avec succès pour être annulés.';
$lang['AdminClients.!success.services_scheduled_uncancel'] = 'Il n\'est plus prévu d\'annuler les services sélectionnés.';
$lang['AdminClients.!success.services_renewed'] = 'Les services sélectionnés ont été renouvelés avec succès.';
$lang['AdminClients.!success.services_pushed'] = 'Les services sélectionnés ont été transférés avec succès au nouveau client.';
$lang['AdminClients.!success.suspend_date_updated'] = 'La date de suspension automatique a été mise à jour avec succès.';
$lang['AdminClients.!success.passwordreset.sent'] = 'Le courriel de réinitialisation du mot de passe a été envoyé avec succès.';
$lang['AdminClients.!error.invoices_emailinvalid'] = 'L\'adresse électronique n\'est pas valide.';
$lang['AdminClients.!error.password'] = 'Le mot de passe n\'est pas valide.';
$lang['AdminClients.!error.pay_with.required'] = 'Vous devez sélectionner un mode de paiement.';
$lang['AdminClients.!error.invoice_credits.required'] = 'Veuillez sélectionner une facture à laquelle des crédits peuvent être appliqués.';
$lang['AdminClients.!error.quotation_invalid_status'] = 'Le statut sélectionné n\'est pas valide.';
$lang['AdminClients.!error.future_cancel_date'] = 'La date d\'annulation prévue ne doit pas être antérieure.';
$lang['AdminClients.!error.invoices_not_voided'] = 'Les factures suivantes n\'ont pas pu être annulées car elles contiennent des paiements partiels : %1$s.';
$lang['AdminClients.!error.passwordreset.failed'] = 'Le courriel de réinitialisation du mot de passe n\'a pas été envoyé.';
$lang['AdminClients.!error.invoices_renew_service'] = 'Le service ne peut pas être renouvelé tant que toutes les factures relatives à ce service n\'ont pas été payées.';
$lang['AdminClients.!notice.invoice_tax_rules_differ'] = 'ATTENTION : Cette facture contient des règles fiscales qui ne sont plus en vigueur. L\'ajout ou la suppression d\'un poste ou la mise à jour de la quantité, du coût unitaire ou du statut fiscal appliquera les règles fiscales les plus récentes à cette facture.';
$lang['AdminClients.!notice.payment_type'] = 'AVERTISSEMENT : Les paiements %1$s ne sont pas activés pour le moment. Pour les activer, mettez à jour la page <a href="%2$s">%3$s</a>.';
$lang['AdminClients.!notice.transactions_already_applied'] = 'ATTENTION : Modifier le statut de cette transaction supprimera cette transaction de toutes les factures en cours d\'application.';
$lang['AdminClients.!notice.service_in_review'] = 'Le statut de ce service est actuellement %1$s et doit être modifié en %2$s avant de pouvoir être activé. Cette opération peut être effectuée par le biais du widget "Commandes" de la page "Aperçu de la facturation" à l\'aide du plugin "Commandes", ou par un plugin tiers chargé de la gestion des commandes.';
$lang['AdminClients.!notice.queued_service_change'] = 'Ce service a des modifications en attente. La mise à jour de ce service pour augmenter ou diminuer l\'une de ses valeurs entraînera l\'annulation des modifications en cours.';
$lang['AdminClients.!notice.delete_client'] = 'Cette action supprime définitivement le client et tous les enregistrements qui lui sont associés (contacts, services, factures, transactions, comptes de paiement, etc.) IL S\'AGIT D\'UNE ACTION PERMANENTE ET IRRÉVOCABLE.';
$lang['AdminClients.!notice.passwordreset.client_inactive'] = 'Le courriel de réinitialisation du mot de passe ne peut être envoyé que pour les clients actifs.';
$lang['AdminClients.!notice.client_limit'] = 'Ce client a atteint le nombre maximum de services pour ce forfait.';
$lang['AdminClients.!notice.force_email_usernames'] = 'Votre nom d\'utilisateur sera le même que votre adresse e-mail.';
$lang['AdminClients.!notice.ach_verification'] = 'Vous devrez vérifier ce compte avant de pouvoir l\'utiliser pour effectuer un paiement.';
$lang['AdminClients.!notice.ach_edit'] = 'Après avoir modifié ce compte, vous devrez le vérifier avant de pouvoir l\'utiliser pour effectuer un paiement.';
$lang['AdminClients.!notice.void_invoice_pending_services'] = 'Vous tentez d\'annuler une ou plusieurs factures auxquelles sont associés des services en attente. Si la facture est annulée, rien ne sera dû pour le service en attente et celui-ci sera activé.';
$lang['AdminClients.!tooltip.module_row_id'] = 'Le changement de cette option mettra à jour la ligne du module utilisée pour ce service dans Blesta uniquement. Cela peut avoir une incidence sur la manière dont le service sera renouvelé avec le module à l\'avenir.';
$lang['AdminClients.!tooltip.notify_cancel'] = 'L\'e-mail d\'annulation ne sera envoyé que si l\'annulation a lieu immédiatement. Dans le cas contraire, l\'e-mail d\'annulation programmé sera envoyé immédiatement, et l\'e-mail d\'annulation sera envoyé au moment de l\'annulation, en fonction des paramètres de l\'entreprise ou du groupe de clients qui contrôlent ce comportement.';
$lang['AdminClients.!tooltip.reset_contact_id'] = 'Le courriel de réinitialisation du mot de passe sera envoyé au contact sélectionné et contiendra un lien lui permettant de modifier le mot de passe de son compte.';
$lang['AdminClients.!tooltip.taxexempt'] = 'Ce champ est géré automatiquement par le système fiscal.';
$lang['AdminClients.!tooltip.client_taxempt'] = 'Ce client est considéré comme exonéré d\'impôt.';
$lang['AdminClients.index.page_title'] = 'Clients';
$lang['AdminClients.index.boxtitle_browseclients'] = 'Clients';
$lang['AdminClients.index.heading_client'] = 'Identifiant du client';
$lang['AdminClients.index.heading_group'] = 'Groupe';
$lang['AdminClients.index.heading_name'] = 'Nom';
$lang['AdminClients.index.heading_company'] = 'Entreprise';
$lang['AdminClients.index.heading_email'] = 'Courriel';
$lang['AdminClients.index.category_active'] = 'Actif';
$lang['AdminClients.index.category_inactive'] = 'Inactif';
$lang['AdminClients.index.category_fraud'] = 'Fraude';
$lang['AdminClients.index.categorylink_clientsadd'] = 'Ajouter un client';
$lang['AdminClients.index.no_results'] = 'Aucun client n\'a ce statut.';
$lang['AdminClients.add.page_title'] = 'Clients Créer un nouveau client';
$lang['AdminClients.add.boxtitle_newclient'] = 'Nouveau client';
$lang['AdminClients.add.heading_contact'] = 'Informations sur le contact';
$lang['AdminClients.add.heading_billing'] = 'Informations sur la facturation';
$lang['AdminClients.add.heading_authentication'] = 'Authentification';
$lang['AdminClients.add.heading_settings'] = 'Paramètres supplémentaires';
$lang['AdminClients.add.field_firstname'] = 'Prénom';
$lang['AdminClients.add.field_lastname'] = 'Nom de famille';
$lang['AdminClients.add.field_company'] = 'Entreprise/Org.';
$lang['AdminClients.add.field_title'] = 'Titre';
$lang['AdminClients.add.field_address1'] = 'Adresse 1';
$lang['AdminClients.add.field_address2'] = 'Adresse 2';
$lang['AdminClients.add.field_city'] = 'Ville';
$lang['AdminClients.add.field_state'] = 'État/Province';
$lang['AdminClients.add.field_zip'] = 'Code postal';
$lang['AdminClients.add.field_country'] = 'Pays';
$lang['AdminClients.add.field_email'] = 'Courriel';
$lang['AdminClients.add.field_username_type_email'] = 'Utiliser l\'email comme nom d\'utilisateur';
$lang['AdminClients.add.field_username_type_username'] = 'Spécifier un nom d\'utilisateur';
$lang['AdminClients.add.field_username'] = 'Nom d\'utilisateur';
$lang['AdminClients.add.field_newpassword'] = 'Mot de passe';
$lang['AdminClients.add.text_generate_password'] = 'Générer un mot de passe';
$lang['AdminClients.add.field_taxexempt'] = 'Exemption fiscale';
$lang['AdminClients.add.field_taxid'] = 'Numéro d\'identification fiscale/VATIN';
$lang['AdminClients.add.field_preferredcurrency'] = 'Monnaie privilégiée';
$lang['AdminClients.add.field_language'] = 'Langue';
$lang['AdminClients.add.field_clientgroup'] = 'Groupe de clients';
$lang['AdminClients.add.field_send_registration_email'] = 'Envoyer l\'e-mail d\'enregistrement du compte';
$lang['AdminClients.add.field_send_registration_message'] = 'Envoyer un message d\'enregistrement de compte';
$lang['AdminClients.add.field_receive_email_marketing'] = 'Accepter de recevoir des courriels de marketing';
$lang['AdminClients.add.field_clientsubmit'] = 'Créer un client';
$lang['AdminClients.accounts.page_title'] = 'Comptes de paiement du client #%1$s';
$lang['AdminClients.accounts.boxtitle_accounts'] = 'Comptes de paiement';
$lang['AdminClients.accounts.categorylink_ach'] = 'Ajouter un compte ACH';
$lang['AdminClients.accounts.categorylink_cc'] = 'Ajouter un compte CC';
$lang['AdminClients.accounts.text_name'] = 'Nom';
$lang['AdminClients.accounts.text_type'] = 'Type';
$lang['AdminClients.accounts.text_last4'] = 'Les 4 derniers';
$lang['AdminClients.accounts.text_options'] = 'Options';
$lang['AdminClients.accounts.confirm_delete'] = 'Supprimer vraiment ce compte de paiement ?';
$lang['AdminClients.accounts.option_verify'] = 'Vérifier';
$lang['AdminClients.accounts.option_edit'] = 'Editer';
$lang['AdminClients.accounts.option_delete'] = 'Supprimer';
$lang['AdminClients.accounts.type_cc'] = '%1$s - %2$s, expire %3$s';
$lang['AdminClients.accounts.type_ach'] = '%1$s - %2$s';
$lang['AdminClients.accounts.field_accountsubmit'] = 'Utilisation pour le débit automatique';
$lang['AdminClients.accounts.no_results'] = 'Il n\'y a pas de comptes ACH ou CC.';
$lang['AdminClients.addccaccount.page_title'] = 'Client #%1$s Ajouter un compte de carte de crédit';
$lang['AdminClients.addccaccount.boxtitle_addccaccount'] = 'Ajouter un compte de carte de crédit';
$lang['AdminClients.addccaccount.field_accountsubmit'] = 'Créer un compte';
$lang['AdminClients.addccaccount.text_none'] = 'Aucun';
$lang['AdminClients.addCcAccount.text_cc'] = 'Carte de crédit';
$lang['AdminClients.addachaccount.page_title'] = 'Client #%1$s Ajouter un compte ACH';
$lang['AdminClients.addachaccount.boxtitle_addachaccount'] = 'Ajouter un compte ACH';
$lang['AdminClients.addachaccount.field_accountsubmit'] = 'Créer un compte';
$lang['AdminClients.addAchAccount.text_ach'] = 'ACH';
$lang['AdminClients.editccaccount.page_title'] = 'Client #%1$s Edit Credit Card Account';
$lang['AdminClients.editccaccount.boxtitle_editccaccount'] = 'Modifier le compte de la carte de crédit';
$lang['AdminClients.editccaccount.field_accountsubmit'] = 'Modifier le compte';
$lang['AdminClients.editachaccount.page_title'] = 'Client #%1$s Modifier le compte ACH';
$lang['AdminClients.editachaccount.boxtitle_editachaccount'] = 'Modifier le compte ACH';
$lang['AdminClients.editachaccount.field_accountsubmit'] = 'Modifier le compte';
$lang['AdminClients.verifyachaccount.field_firstdeposit'] = 'Premier dépôt';
$lang['AdminClients.verifyachaccount.field_seconddeposit'] = 'Deuxième dépôt';
$lang['AdminClients.verifyachaccount.boxtitle_verifyachaccount'] = 'Vérifier le compte ACH';
$lang['AdminClients.verifyachaccount.heading_deposits'] = 'Dépôts de vérification';
$lang['AdminClients.verifyachaccount.field_accountsubmit'] = 'Vérifier le compte';
$lang['AdminClients.verifyAchAccount.text_ach'] = 'ACH';
$lang['AdminClients.addcontact.page_title'] = 'Client #%1$s Nouveau contact';
$lang['AdminClients.addcontact.boxtitle_newcontact'] = 'Nouveau contact';
$lang['AdminClients.addcontact.heading_contact'] = 'Informations sur le contact';
$lang['AdminClients.addcontact.heading_authentication'] = 'Authentification';
$lang['AdminClients.addcontact.field_enable_login'] = 'Activer la connexion';
$lang['AdminClients.addcontact.field_username'] = 'Nom d\'utilisateur';
$lang['AdminClients.addcontact.field_newpassword'] = 'Mot de passe';
$lang['AdminClients.addcontact.text_generate_password'] = 'Générer un mot de passe';
$lang['AdminClients.addcontact.field_permissions'] = 'Permissions';
$lang['AdminClients.addcontact.heading_settings'] = 'Paramètres supplémentaires';
$lang['AdminClients.addcontact.field_firstname'] = 'Prénom';
$lang['AdminClients.addcontact.field_lastname'] = 'Nom de famille';
$lang['AdminClients.addcontact.field_company'] = 'Entreprise/Org.';
$lang['AdminClients.addcontact.field_title'] = 'Titre';
$lang['AdminClients.addcontact.field_address1'] = 'Adresse 1';
$lang['AdminClients.addcontact.field_address2'] = 'Adresse 2';
$lang['AdminClients.addcontact.field_city'] = 'Ville';
$lang['AdminClients.addcontact.field_state'] = 'État/Province';
$lang['AdminClients.addcontact.field_zip'] = 'Code postal';
$lang['AdminClients.addcontact.field_country'] = 'Pays';
$lang['AdminClients.addcontact.field_email'] = 'Courriel';
$lang['AdminClients.addcontact.field_accounttype'] = 'Type de compte';
$lang['AdminClients.addcontact.field_contactsubmit'] = 'Créer un contact';
$lang['AdminClients.createinvoice.page_title'] = 'Client #%1$s Créer une facture';
$lang['AdminClients.createinvoice.boxtitle_createinvoice'] = 'Créer une facture';
$lang['AdminClients.createinvoice.heading_description'] = 'Description';
$lang['AdminClients.createinvoice.heading_quantity'] = 'Quantité';
$lang['AdminClients.createinvoice.heading_unitcost'] = 'Coût unitaire';
$lang['AdminClients.createinvoice.heading_tax'] = 'Impôts';
$lang['AdminClients.createinvoice.heading_options'] = 'Options';
$lang['AdminClients.createinvoice.heading_term'] = 'Durée';
$lang['AdminClients.createinvoice.heading_period'] = 'Période';
$lang['AdminClients.createinvoice.heading_duration'] = 'Durée de l\'accord';
$lang['AdminClients.createinvoice.heading_nextbilldate'] = 'Prochaine date de renouvellement';
$lang['AdminClients.createinvoice.option_add'] = 'Ajouter';
$lang['AdminClients.createinvoice.option_delete'] = 'Supprimer';
$lang['AdminClients.createinvoice.field_datebilled'] = 'Date de facturation :';
$lang['AdminClients.createinvoice.field_datedue'] = 'Date d\'échéance :';
$lang['AdminClients.createinvoice.field_invoicedelivery'] = 'Livraison de la facture :';
$lang['AdminClients.createinvoice.field_autodebit'] = 'Débit automatique :';
$lang['AdminClients.createinvoice.field_autodebit_text'] = 'Autoriser le débit automatique pour cette facture';
$lang['AdminClients.createinvoice.tooltip_autodebit'] = 'En cochant cette case, cette facture sera débitée automatiquement si le débit automatique est activé et disponible pour le client.';
$lang['AdminClients.createinvoice.field_currency'] = 'Monnaie';
$lang['AdminClients.createinvoice.field_duration_indefinitely'] = 'Indéfiniment';
$lang['AdminClients.createinvoice.field_duration_times'] = 'nombre de fois';
$lang['AdminClients.createinvoice.field_notepublic'] = 'Note publique :';
$lang['AdminClients.createinvoice.field_noteprivate'] = 'Note privée :';
$lang['AdminClients.createinvoice.field_invoicesubmit'] = 'Créer';
$lang['AdminClients.createinvoice.field_invoicedraft'] = 'Enregistrer comme brouillon';
$lang['AdminClients.createinvoice.section_recurringinvoice'] = 'Facture récurrente';
$lang['AdminClients.createinvoice.section_notes'] = 'Notes';
$lang['AdminClients.createinvoice.price_subtotal'] = 'Sous-total :';
$lang['AdminClients.createinvoice.auto_save_saving'] = 'Sauvegarde en tant que brouillon...';
$lang['AdminClients.createinvoice.auto_save_saved'] = 'Projet sauvegardé';
$lang['AdminClients.createinvoice.auto_save_error'] = 'Le projet n\'a pas pu être enregistré automatiquement';
$lang['AdminClients.createquotation.page_title'] = 'Client #%1$s Créer un devis';
$lang['AdminClients.createquotation.boxtitle_createquotation'] = 'Créer un devis';
$lang['AdminClients.createquotation.heading_description'] = 'Description';
$lang['AdminClients.createquotation.heading_quantity'] = 'Quantité';
$lang['AdminClients.createquotation.heading_unitcost'] = 'Coût unitaire';
$lang['AdminClients.createquotation.heading_tax'] = 'Impôts';
$lang['AdminClients.createquotation.heading_options'] = 'Options';
$lang['AdminClients.createquotation.option_add'] = 'Ajouter';
$lang['AdminClients.createquotation.option_delete'] = 'Supprimer';
$lang['AdminClients.createquotation.field_title'] = 'Titre';
$lang['AdminClients.createquotation.field_date_created'] = 'Date de création :';
$lang['AdminClients.createquotation.field_date_expires'] = 'Date d\'expiration :';
$lang['AdminClients.createquotation.field_currency'] = 'Monnaie';
$lang['AdminClients.createquotation.field_notes'] = 'Notes :';
$lang['AdminClients.createquotation.field_private_notes'] = 'Notes privées :';
$lang['AdminClients.createquotation.field_quotationsubmit'] = 'Créer';
$lang['AdminClients.createquotation.field_quotationdraft'] = 'Enregistrer comme brouillon';
$lang['AdminClients.createquotation.section_notes'] = 'Notes';
$lang['AdminClients.createquotation.price_subtotal'] = 'Sous-total :';
$lang['AdminClients.createquotation.auto_save_saving'] = 'Sauvegarde en tant que brouillon...';
$lang['AdminClients.createquotation.auto_save_saved'] = 'Projet sauvegardé';
$lang['AdminClients.createquotation.auto_save_error'] = 'Le projet n\'a pas pu être enregistré automatiquement';
$lang['AdminClients.editquotation.page_title'] = 'Client #%1$s Editer le devis';
$lang['AdminClients.editquotation.boxtitle_editquotation'] = 'Modifier la citation [%1$s]';
$lang['AdminClients.editquotation.heading_description'] = 'Description';
$lang['AdminClients.editquotation.heading_quantity'] = 'Quantité';
$lang['AdminClients.editquotation.heading_unitcost'] = 'Coût unitaire';
$lang['AdminClients.editquotation.heading_tax'] = 'Impôts';
$lang['AdminClients.editquotation.heading_options'] = 'Options';
$lang['AdminClients.editquotation.option_add'] = 'Ajouter';
$lang['AdminClients.editquotation.option_delete'] = 'Supprimer';
$lang['AdminClients.editquotation.field_title'] = 'Titre';
$lang['AdminClients.editquotation.field_date_created'] = 'Date de création :';
$lang['AdminClients.editquotation.field_date_expires'] = 'Date d\'expiration :';
$lang['AdminClients.editquotation.field_currency'] = 'Monnaie';
$lang['AdminClients.editquotation.field_notes'] = 'Notes :';
$lang['AdminClients.editquotation.field_private_notes'] = 'Notes privées :';
$lang['AdminClients.editquotation.field_quotationsubmit'] = 'Économiser';
$lang['AdminClients.editquotation.field_quotationsavedraft'] = 'Enregistrer comme brouillon';
$lang['AdminClients.editquotation.section_notes'] = 'Notes';
$lang['AdminClients.editquotation.price_subtotal'] = 'Sous-total :';
$lang['AdminClients.editquotation.auto_save_saving'] = 'Sauvegarde en tant que brouillon...';
$lang['AdminClients.editquotation.auto_save_saved'] = 'Projet sauvegardé';
$lang['AdminClients.editquotation.auto_save_error'] = 'Le projet n\'a pas pu être enregistré automatiquement';
$lang['AdminClients.invoicequotation.field_invoice_single'] = 'Facture unique';
$lang['AdminClients.invoicequotation.field_invoice_two'] = 'Deux factures';
$lang['AdminClients.invoicequotation.field_due_date'] = 'Date d\'échéance';
$lang['AdminClients.invoicequotation.field_first_due_date'] = 'Première échéance';
$lang['AdminClients.invoicequotation.field_second_due_date'] = 'Deuxième échéance';
$lang['AdminClients.invoicequotation.field_percentage_due'] = 'Pourcentage dû (%)';
$lang['AdminClients.invoicequotation.field_submit'] = 'Créer une facture';
$lang['AdminClients.edit.page_title'] = 'Client #%1$s Modifier le client';
$lang['AdminClients.edit.boxtitle_editclient'] = 'Modifier le client';
$lang['AdminClients.edit.heading_contact'] = 'Informations sur le contact';
$lang['AdminClients.edit.heading_billing'] = 'Informations sur la facturation';
$lang['AdminClients.edit.heading_authentication'] = 'Authentification';
$lang['AdminClients.edit.heading_settings'] = 'Paramètres supplémentaires';
$lang['AdminClients.edit.field_firstname'] = 'Prénom';
$lang['AdminClients.edit.field_lastname'] = 'Nom de famille';
$lang['AdminClients.edit.field_company'] = 'Société/Org.';
$lang['AdminClients.edit.field_title'] = 'Titre';
$lang['AdminClients.edit.field_address1'] = 'Adresse 1';
$lang['AdminClients.edit.field_address2'] = 'Adresse 2';
$lang['AdminClients.edit.field_city'] = 'Ville';
$lang['AdminClients.edit.field_state'] = 'État/Province';
$lang['AdminClients.edit.field_zip'] = 'Code postal';
$lang['AdminClients.edit.field_country'] = 'Pays';
$lang['AdminClients.edit.field_email'] = 'Courriel';
$lang['AdminClients.edit.field_username_type_email'] = 'Utiliser l\'email comme nom d\'utilisateur';
$lang['AdminClients.edit.field_username_type_username'] = 'Spécifier un nom d\'utilisateur';
$lang['AdminClients.edit.field_username'] = 'Nom d\'utilisateur';
$lang['AdminClients.edit.field_newpassword'] = 'Mot de passe';
$lang['AdminClients.edit.field_two_factor_mode'] = 'Authentification à deux facteurs';
$lang['AdminClients.edit.field_two_factor_mode_off'] = 'Non activé';
$lang['AdminClients.edit.field_two_factor_mode_on'] = 'Désactiver l\'authentification à deux facteurs (actuellement activée)';
$lang['AdminClients.edit.field_taxexempt'] = 'Exemption fiscale';
$lang['AdminClients.edit.field_taxid'] = 'Numéro d\'identification fiscale/VATIN';
$lang['AdminClients.edit.field_preferredcurrency'] = 'Monnaie privilégiée';
$lang['AdminClients.edit.field_invoiceaddress'] = 'Adresser les factures à';
$lang['AdminClients.edit.field_language'] = 'Langue';
$lang['AdminClients.edit.field_clientgroup'] = 'Groupe de clients';
$lang['AdminClients.edit.field_receive_email_marketing'] = 'Accepter de recevoir des courriels de marketing';
$lang['AdminClients.edit.field_clientsubmit'] = 'Modifier le client';
$lang['AdminClients.accountachinfo.heading_account'] = 'Informations sur le compte bancaire';
$lang['AdminClients.accountachinfo.field_type'] = 'Type';
$lang['AdminClients.accountachinfo.field_accountnum'] = 'Numéro de compte';
$lang['AdminClients.accountachinfo.field_routingnum'] = 'Numéro de routage';
$lang['AdminClients.accountachinfo.field_savedetails'] = 'Sauvegarder le compte';
$lang['AdminClients.accountachinfo.text_showaccount'] = 'Afficher le compte';
$lang['AdminClients.accountccinfo.heading_cc'] = 'Informations sur la carte de crédit';
$lang['AdminClients.accountccinfo.field_number'] = 'Nombre';
$lang['AdminClients.accountccinfo.field_security'] = 'Code de sécurité';
$lang['AdminClients.accountccinfo.field_expiration'] = 'Date d\'expiration';
$lang['AdminClients.accountccinfo.field_savedetails'] = 'Sauvegarder le compte';
$lang['AdminClients.accountccinfo.text_showcard'] = 'Afficher la carte';
$lang['AdminClients.accountccinfo.tooltip_code'] = 'Le code de sécurité à 3 ou 4 chiffres, qui se trouve généralement au dos de la carte.';
$lang['AdminClients.accounttypes.heading_types'] = 'Types de paiement acceptés';
$lang['AdminClients.accounttypes.submit_settings'] = 'Mise à jour des paramètres';
$lang['AdminClients.accounttypes.cancel'] = 'Annuler';
$lang['AdminClients.accountcontactinfo.heading_contact'] = 'Informations sur le contact';
$lang['AdminClients.accountcontactinfo.field_contact_id'] = 'Copier les informations de contact de';
$lang['AdminClients.accountcontactinfo.field_first_name'] = 'Prénom';
$lang['AdminClients.accountcontactinfo.field_last_name'] = 'Nom de famille';
$lang['AdminClients.accountcontactinfo.field_address1'] = 'Adresse 1';
$lang['AdminClients.accountcontactinfo.field_address2'] = 'Adresse 2';
$lang['AdminClients.accountcontactinfo.field_city'] = 'Ville';
$lang['AdminClients.accountcontactinfo.field_country'] = 'Pays';
$lang['AdminClients.accountcontactinfo.field_state'] = 'État';
$lang['AdminClients.accountcontactinfo.field_zip'] = 'Code postal';
$lang['AdminClients.phones.categorylink_number'] = 'Ajouter un numéro supplémentaire';
$lang['AdminClients.phones.rowheading_number'] = 'Numéros de téléphone';
$lang['AdminClients.phones.text_remove'] = 'Retirer';
$lang['AdminClients.phones.field_phonetype'] = 'Type';
$lang['AdminClients.phones.field_phonelocation'] = 'Localisation';
$lang['AdminClients.phones.field_phonenumber'] = 'Nombre';
$lang['AdminClients.editcontact.page_title'] = 'Client #%1$s Modifier le contact';
$lang['AdminClients.editcontact.boxtitle_editcontact'] = 'Modifier le contact';
$lang['AdminClients.editcontact.heading_contact'] = 'Informations sur le contact';
$lang['AdminClients.editcontact.heading_authentication'] = 'Authentification';
$lang['AdminClients.editcontact.field_enable_login'] = 'Activer la connexion';
$lang['AdminClients.editcontact.field_username'] = 'Nom d\'utilisateur';
$lang['AdminClients.editcontact.field_newpassword'] = 'Mot de passe';
$lang['AdminClients.editcontact.text_generate_password'] = 'Générer un mot de passe';
$lang['AdminClients.editcontact.field_two_factor_mode'] = 'Authentification à deux facteurs';
$lang['AdminClients.editcontact.field_two_factor_mode_off'] = 'Non activé';
$lang['AdminClients.editcontact.field_two_factor_mode_on'] = 'Désactiver l\'authentification à deux facteurs (actuellement activée)';
$lang['AdminClients.editcontact.field_permissions'] = 'Permissions';
$lang['AdminClients.editcontact.heading_settings'] = 'Paramètres supplémentaires';
$lang['AdminClients.editcontact.field_firstname'] = 'Prénom';
$lang['AdminClients.editcontact.field_lastname'] = 'Nom de famille';
$lang['AdminClients.editcontact.field_company'] = 'Entreprise/Org.';
$lang['AdminClients.editcontact.field_title'] = 'Titre';
$lang['AdminClients.editcontact.field_address1'] = 'Adresse 1';
$lang['AdminClients.editcontact.field_address2'] = 'Adresse 2';
$lang['AdminClients.editcontact.field_city'] = 'Ville';
$lang['AdminClients.editcontact.field_state'] = 'État/Province';
$lang['AdminClients.editcontact.field_zip'] = 'Code postal';
$lang['AdminClients.editcontact.field_country'] = 'Pays';
$lang['AdminClients.editcontact.field_email'] = 'Courriel';
$lang['AdminClients.editcontact.field_contacttype'] = 'Type de contact';
$lang['AdminClients.editcontact.field_contactsubmit'] = 'Modifier le contact';
$lang['AdminClients.editcontact.field_deletecontact'] = 'Supprimer un contact';
$lang['AdminClients.editcontact.confirm_delete'] = 'Êtes-vous sûr de vouloir supprimer ce contact ?';
$lang['AdminClients.editinvoice.page_title'] = 'Client #%1$s Editer la facture #%2$s';
$lang['AdminClients.editinvoice.boxtitle_editinvoice'] = 'Modifier la facture [%1$s]';
$lang['AdminClients.editinvoice.boxtitle_editdraft'] = 'Modifier le projet de facture [%1$s]';
$lang['AdminClients.editinvoice.heading_description'] = 'Description';
$lang['AdminClients.editinvoice.heading_quantity'] = 'Quantité';
$lang['AdminClients.editinvoice.heading_unitcost'] = 'Coût unitaire';
$lang['AdminClients.editinvoice.heading_tax'] = 'Impôts';
$lang['AdminClients.editinvoice.heading_options'] = 'Options';
$lang['AdminClients.editinvoice.heading_term'] = 'Durée';
$lang['AdminClients.editinvoice.heading_period'] = 'Période';
$lang['AdminClients.editinvoice.heading_duration'] = 'La durée';
$lang['AdminClients.editinvoice.heading_nextbilldate'] = 'Prochaine date de renouvellement';
$lang['AdminClients.editinvoice.option_add'] = 'Ajouter';
$lang['AdminClients.editinvoice.option_delete'] = 'Supprimer';
$lang['AdminClients.editinvoice.field_datebilled'] = 'Date de facturation :';
$lang['AdminClients.editinvoice.field_datedue'] = 'Date d\'échéance :';
$lang['AdminClients.editinvoice.field_invoicedelivery'] = 'Livraison de la facture :';
$lang['AdminClients.editinvoice.field_autodebit'] = 'Débit automatique :';
$lang['AdminClients.editinvoice.field_autodebit_text'] = 'Autoriser le débit automatique pour cette facture';
$lang['AdminClients.editinvoice.tooltip_autodebit'] = 'En cochant cette case, cette facture sera débitée automatiquement si le débit automatique est activé et disponible pour le client.';
$lang['AdminClients.editinvoice.field_recache'] = 'Recache :';
$lang['AdminClients.editinvoice.field_recache_text'] = 'Recache cette facture sur la mise à jour';
$lang['AdminClients.editinvoice.tooltip_recache'] = 'Si vous cochez cette case, la facture mise en cache sera remplacée par les données actualisées lors de l\'enregistrement.';
$lang['AdminClients.editinvoice.field_currency'] = 'Monnaie';
$lang['AdminClients.editinvoice.field_duration_indefinitely'] = 'Indéfiniment';
$lang['AdminClients.editinvoice.field_duration_times'] = 'nombre de fois';
$lang['AdminClients.editinvoice.field_notepublic'] = 'Note publique :';
$lang['AdminClients.editinvoice.field_noteprivate'] = 'Note privée :';
$lang['AdminClients.editinvoice.field_invoicesubmit'] = 'Modifier la facture';
$lang['AdminClients.editinvoice.field_invoicedvoid'] = 'Annulation de la facture';
$lang['AdminClients.editinvoice.field_invoicecreate'] = 'Créer';
$lang['AdminClients.editinvoice.field_invoicesavedraft'] = 'Sauvegarder le projet';
$lang['AdminClients.editinvoice.field_invoiceunvoid'] = 'Annuler et modifier';
$lang['AdminClients.editinvoice.field_invoicedelete'] = 'Supprimer une facture';
$lang['AdminClients.editinvoice.section_recurringinvoice'] = 'Facture récurrente';
$lang['AdminClients.editinvoice.section_notes'] = 'Notes';
$lang['AdminClients.editinvoice.price_subtotal'] = 'Sous-total :';
$lang['AdminClients.editinvoice.auto_save_saving'] = 'Sauvegarde du projet...';
$lang['AdminClients.editinvoice.auto_save_saved'] = 'Projet sauvegardé';
$lang['AdminClients.editinvoice.auto_save_error'] = 'Le projet n\'a pas pu être enregistré automatiquement';
$lang['AdminClients.editinvoice.field_continue'] = 'Continuer';
$lang['AdminClients.editinvoice.field_cancel'] = 'Annuler';
$lang['AdminClients.editrecurinvoice.page_title'] = 'Client #%1$s Editer la facture récurrente #%2$s';
$lang['AdminClients.editrecurinvoice.boxtitle_editinvoice'] = 'Modifier la facture récurrente [%1$s]';
$lang['AdminClients.editinvoice.confirm_deleterecur'] = 'Cette opération supprimera définitivement cette facture périodique. Aucune autre facture ne sera générée à partir de cette facture récurrente. Etes-vous sûr de vouloir la supprimer ?';
$lang['AdminClients.edittransaction.page_title'] = 'Client #%1$s Modifier la transaction';
$lang['AdminClients.edittransaction.boxtitle_edittransaction'] = 'Modifier la transaction';
$lang['AdminClients.edittransaction.heading_type'] = 'Type';
$lang['AdminClients.edittransaction.heading_amount'] = 'Montant';
$lang['AdminClients.edittransaction.heading_credited'] = 'Crédité';
$lang['AdminClients.edittransaction.heading_applied'] = 'Appliqué';
$lang['AdminClients.edittransaction.heading_number'] = 'Nombre';
$lang['AdminClients.edittransaction.heading_status'] = 'Statut';
$lang['AdminClients.edittransaction.heading_date'] = 'Date';
$lang['AdminClients.edittransaction.subheading_invoice'] = 'Facture #';
$lang['AdminClients.edittransaction.subheading_amount'] = 'Montant';
$lang['AdminClients.edittransaction.subheading_appliedon'] = 'Appliqué le';
$lang['AdminClients.edittransaction.subheading_options'] = 'Options';
$lang['AdminClients.edittransaction.field_status'] = 'Statut';
$lang['AdminClients.edittransaction.field_processremotely'] = 'Traiter ce changement de statut avec la passerelle de paiement (%1$s)';
$lang['AdminClients.edittransaction.field_submit'] = 'Modifier la transaction';
$lang['AdminClients.edittransaction.applied_no_results'] = 'Cette transaction n\'a été appliquée à aucune facture.';
$lang['AdminClients.edittransaction.option_unapply'] = 'Désapplication';
$lang['AdminClients.edittransaction.confirm_unapply'] = 'Cette transaction est-elle vraiment supprimée de la facture sélectionnée ?';
$lang['AdminClients.email.page_title'] = 'Client #%1$s Email Client';
$lang['AdminClients.email.boxtitle_emailclient'] = 'Client de messagerie';
$lang['AdminClients.email.field_recipient'] = 'Bénéficiaire';
$lang['AdminClients.email.field_fromname'] = 'Du nom';
$lang['AdminClients.email.field_from'] = 'De l\'email';
$lang['AdminClients.email.field_subject'] = 'Sujet';
$lang['AdminClients.email.field_message'] = 'Texte';
$lang['AdminClients.email.field_messagehtml'] = 'HTML';
$lang['AdminClients.email.field_emailsubmit'] = 'Envoyer un courriel';
$lang['AdminClients.emails.page_title'] = 'Client #%1$s Mail Log';
$lang['AdminClients.emails.boxtitle_maillog'] = 'Journal du courrier';
$lang['AdminClients.emails.heading_date'] = 'Date';
$lang['AdminClients.emails.heading_subject'] = 'Sujet';
$lang['AdminClients.emails.heading_summary'] = 'Résumé';
$lang['AdminClients.emails.text_to'] = 'Pour';
$lang['AdminClients.emails.text_cc'] = 'CC';
$lang['AdminClients.emails.text_from'] = 'De';
$lang['AdminClients.emails.text_resend'] = 'Renvoyer';
$lang['AdminClients.emails.no_results'] = 'Il n\'y a pas de courrier électronique.';
$lang['AdminClients.passwordreset.page_title'] = 'Réinitialisation du mot de passe du client #%1$s';
$lang['AdminClients.passwordreset.boxtitle_passwordreset'] = 'Envoyer la réinitialisation du mot de passe';
$lang['AdminClients.passwordreset.field_contact_id'] = 'Contact';
$lang['AdminClients.passwordreset.contact_id_name'] = '%1$s %2$s (%3$s) %4$s';
$lang['AdminClients.passwordreset.field_submit'] = 'Envoyer un courriel';
$lang['AdminClients.invoices.page_title'] = 'Factures du client #%1$s';
$lang['AdminClients.invoices.boxtitle_invoices'] = 'Factures';
$lang['AdminClients.invoices.heading_invoice'] = 'Facture #';
$lang['AdminClients.invoices.heading_recurinvoice'] = 'Récurrents #';
$lang['AdminClients.invoices.heading_amount'] = 'Montant';
$lang['AdminClients.invoices.heading_paid'] = 'Payé';
$lang['AdminClients.invoices.heading_due'] = 'Due';
$lang['AdminClients.invoices.heading_dateclosed'] = 'Date de clôture';
$lang['AdminClients.invoices.heading_datebilled'] = 'Date de facturation';
$lang['AdminClients.invoices.heading_datedue'] = 'Date d\'échéance';
$lang['AdminClients.invoices.heading_status'] = 'Statut';
$lang['AdminClients.invoices.heading_options'] = 'Options';
$lang['AdminClients.invoices.heading_term'] = 'Durée';
$lang['AdminClients.invoices.heading_duration'] = 'La durée';
$lang['AdminClients.invoices.heading_count'] = 'Compter';
$lang['AdminClients.invoices.category_open'] = 'Ouvrir';
$lang['AdminClients.invoices.category_drafts'] = 'Projets';
$lang['AdminClients.invoices.category_closed'] = 'Fermé';
$lang['AdminClients.invoices.category_voided'] = 'Annulé';
$lang['AdminClients.invoices.category_recurring'] = 'Récurrent';
$lang['AdminClients.invoices.category_pending'] = 'En attente';
$lang['AdminClients.invoices.categorylink_createinvoice'] = 'Créer une facture';
$lang['AdminClients.invoices.headingexpand_paymenttype'] = 'Type de paiement';
$lang['AdminClients.invoices.headingexpand_amount'] = 'Montant';
$lang['AdminClients.invoices.headingexpand_applied'] = 'Appliqué';
$lang['AdminClients.invoices.headingexpand_appliedon'] = 'Appliqué le';
$lang['AdminClients.invoices.headingexpand_options'] = 'Options';
$lang['AdminClients.invoices.status_sent'] = 'Envoyé';
$lang['AdminClients.invoices.status_unsent'] = 'Sans objet';
$lang['AdminClients.invoices.option_edit'] = 'Editer';
$lang['AdminClients.invoices.option_view'] = 'Voir';
$lang['AdminClients.invoices.option_pay'] = 'Payer';
$lang['AdminClients.invoices.option_delete'] = 'Supprimer';
$lang['AdminClients.invoices.confirm_delete'] = 'Êtes-vous sûr de vouloir supprimer ce projet de facture ?';
$lang['AdminClients.invoices.optionexpand_edit'] = 'Editer';
$lang['AdminClients.invoices.action_deliver'] = 'Livrer via %1$s';
$lang['AdminClients.invoices.action_void'] = 'Factures annulées';
$lang['AdminClients.invoices.field_invoicesubmit'] = 'Soumettre';
$lang['AdminClients.invoices.field_continue'] = 'Continuer';
$lang['AdminClients.invoices.field_cancel'] = 'Annuler';
$lang['AdminClients.invoices.no_results'] = 'Aucune facture n\'a ce statut.';
$lang['AdminClients.invoices.applied_no_results'] = 'Cette facture ne fait l\'objet d\'aucune transaction.';
$lang['AdminClients.invoices.subtotal_w_tax'] = '%1$s +taxe';
$lang['AdminClients.invoices.term_day'] = 'jour %1$s';
$lang['AdminClients.invoices.term_week'] = 'Semaine %1$s';
$lang['AdminClients.invoices.term_month'] = 'mois %1$s';
$lang['AdminClients.invoices.term_year'] = '%1$s année';
$lang['AdminClients.invoices.term_day_plural'] = '%1$s jours';
$lang['AdminClients.invoices.term_week_plural'] = 'semaines %1$s';
$lang['AdminClients.invoices.term_month_plural'] = '%1$s mois';
$lang['AdminClients.invoices.term_year_plural'] = '%1$s années';
$lang['AdminClients.invoices.duration_finite'] = '%1$s fois';
$lang['AdminClients.invoices.duration_infinite'] = '∞';
$lang['AdminClients.quotations.page_title'] = 'Citations sur la facturation';
$lang['AdminClients.quotations.boxtitle_quotations'] = 'Citations';
$lang['AdminClients.quotations.heading_quotation'] = 'Citation #';
$lang['AdminClients.quotations.heading_client'] = 'Client #';
$lang['AdminClients.quotations.heading_title'] = 'Titre';
$lang['AdminClients.quotations.heading_staff'] = 'Cité par';
$lang['AdminClients.quotations.heading_subtotal'] = 'Sous-total';
$lang['AdminClients.quotations.heading_total'] = 'Montant';
$lang['AdminClients.quotations.heading_date_created'] = 'Date de création';
$lang['AdminClients.quotations.heading_date_expires'] = 'Date d\'expiration';
$lang['AdminClients.quotations.heading_options'] = 'Options';
$lang['AdminClients.quotations.category_draft'] = 'Projet';
$lang['AdminClients.quotations.category_approved'] = 'Approuvé';
$lang['AdminClients.quotations.category_pending'] = 'En attente';
$lang['AdminClients.quotations.category_expired'] = 'Expiré';
$lang['AdminClients.quotations.category_invoiced'] = 'Facturé';
$lang['AdminClients.quotations.category_dead'] = 'Mort';
$lang['AdminClients.quotations.category_lost'] = 'Perdu';
$lang['AdminClients.quotations.option_edit'] = 'Editer';
$lang['AdminClients.quotations.option_view'] = 'Voir';
$lang['AdminClients.quotations.option_invoice'] = 'Créer une facture';
$lang['AdminClients.quotations.option_approve'] = 'Approuver';
$lang['AdminClients.quotations.confirm_approve'] = 'Êtes-vous sûr de vouloir approuver cette citation ?';
$lang['AdminClients.quotations.categorylink_createquotation'] = 'Créer un devis';
$lang['AdminClients.quotations.field_quotationsubmit'] = 'Soumettre';
$lang['AdminClients.quotations.action.email'] = 'Livraison par courrier électronique';
$lang['AdminClients.quotations.action.status'] = 'Changement d\'état';
$lang['AdminClients.quotations.no_results'] = 'Il n\'y a pas de devis avec ce statut.';
$lang['AdminClients.quotationinvoices.headingexpand_invoice'] = 'Facture #';
$lang['AdminClients.quotationinvoices.headingexpand_amount'] = 'Montant';
$lang['AdminClients.quotationinvoices.headingexpand_paid'] = 'Payé';
$lang['AdminClients.quotationinvoices.headingexpand_date_billed'] = 'Date de facturation';
$lang['AdminClients.quotationinvoices.headingexpand_options'] = 'Options';
$lang['AdminClients.quotationinvoices.option_view'] = 'Voir';
$lang['AdminClients.quotationinvoices.invoices_no_results'] = 'Aucune facture n\'est associée à ce devis.';
$lang['AdminClients.merge.page_title'] = 'Client #%1$s Fusionner les clients';
$lang['AdminClients.merge.boxtitle_merge'] = 'Fusionner des clients';
$lang['AdminClients.merge.field_clientid'] = 'ID du client à fusionner';
$lang['AdminClients.merge.field_mergefrom'] = 'Fusionner le client de';
$lang['AdminClients.merge.field_btoa'] = 'De B à A';
$lang['AdminClients.merge.field_atob'] = 'De A à B';
$lang['AdminClients.merge.field_password'] = 'Mot de passe administrateur';
$lang['AdminClients.merge.field_mergesubmit'] = 'Fusionner des clients';
$lang['AdminClients.stickynotes.date_separator'] = ':';
$lang['AdminClients.stickynotes.text_unstick'] = 'Décoller';
$lang['AdminClients.stickynotes.text_more'] = 'Afficher plus';
$lang['AdminClients.stickynotes.text_less'] = 'Montrer moins';
$lang['AdminClients.notes.page_title'] = 'Notes du client #%1$s';
$lang['AdminClients.notes.boxtitle_notes'] = 'Notes';
$lang['AdminClients.notes.heading_title'] = 'Résumé';
$lang['AdminClients.notes.heading_dateupdated'] = 'Date de mise à jour';
$lang['AdminClients.notes.heading_options'] = 'Options';
$lang['AdminClients.notes.heading_staff'] = 'Créé par';
$lang['AdminClients.notes.heading_dateadded'] = 'Date d\'ajout';
$lang['AdminClients.notes.by_system'] = 'Système';
$lang['AdminClients.notes.categorylink_create'] = 'Créer une note';
$lang['AdminClients.notes.option_edit'] = 'Editer';
$lang['AdminClients.notes.option_delete'] = 'Supprimer';
$lang['AdminClients.notes.confirm_delete'] = 'Êtes-vous sûr de vouloir supprimer cette note ?';
$lang['AdminClients.notes.no_results'] = 'Il n\'y a pas de notes.';
$lang['AdminClients.!notes.stickied'] = 'Cochez cette case pour afficher cette note sur la page du profil du client.';
$lang['AdminClients.addnote.page_title'] = 'Client #%1$s Créer une note';
$lang['AdminClients.addnote.boxtitle_createnote'] = 'Créer une note';
$lang['AdminClients.addnote.field_title'] = 'Résumé';
$lang['AdminClients.addnote.field_description'] = 'Détails';
$lang['AdminClients.addnote.field_stickied'] = 'Coller cette note';
$lang['AdminClients.addnote.field_notesubmit'] = 'Créer une note';
$lang['AdminClients.editnote.page_title'] = 'Client #%1$s Edit Note';
$lang['AdminClients.editnote.boxtitle_editnote'] = 'Note d\'édition';
$lang['AdminClients.editnote.field_title'] = 'Résumé';
$lang['AdminClients.editnote.field_description'] = 'Détails';
$lang['AdminClients.editnote.field_stickied'] = 'Coller cette note';
$lang['AdminClients.editnote.field_notesubmit'] = 'Note d\'édition';
$lang['AdminClients.addservice.status.active'] = 'Actif';
$lang['AdminClients.addservice.status.inactive'] = 'Inactif';
$lang['AdminClients.addservice.status.restricted'] = 'Restreint';
$lang['AdminClients.addservice.page_title'] = 'Client #%1$s Ajouter un service';
$lang['AdminClients.addservice.boxtitle_addservice'] = 'Ajouter un service : %1$s';
$lang['AdminClients.addservice.field_package'] = 'Paquet';
$lang['AdminClients.addservice.field_continue'] = 'Continuer';
$lang['AdminClients.addservice.auto_choose'] = '-- Choisir Automatiquement --';
$lang['AdminClients.addservice.term_onetime'] = 'Onetime - %3$s';
$lang['AdminClients.addservice.term'] = '%1$s %2$s - %3$s';
$lang['AdminClients.addservice.term_recurring'] = '%1$s %2$s - %3$s (renouvellement @ %4$s)';
$lang['AdminClients.addservice.term_dated'] = '%1$s %2$s - %3$s (%4$s - %5$s)';
$lang['AdminClients.addservice_basic.basic_heading'] = 'Options de base';
$lang['AdminClients.addservice_basic.field_invoice_method'] = 'Méthode de facturation';
$lang['AdminClients.addservice_basic.field_invoice_method_create'] = 'Créer une facture';
$lang['AdminClients.addservice_basic.field_invoice_method_append'] = 'Ajouter à la facture';
$lang['AdminClients.addservice_basic.field_invoice_method_dont'] = 'Ne pas facturer';
$lang['AdminClients.addservice_basic.field_term'] = 'Durée';
$lang['AdminClients.addservice_basic.field_status'] = 'Statut';
$lang['AdminClients.addservice_basic.field_notify_order'] = 'Envoi d\'un courriel de confirmation de la commande lorsqu\'elle est activée';
$lang['AdminClients.addservice_basic.field_use_module'] = 'Disposition utilisant le module %1$s lorsqu\'il est activé';
$lang['AdminClients.addservice_basic.module_heading'] = 'Options %1$s';
$lang['AdminClients.addservice_basic.addons_heading'] = 'Compléments';
$lang['AdminClients.addservice_basic.field_default_addon'] = 'Aucun';
$lang['AdminClients.addservice_basic.field_continue'] = 'Continuer';
$lang['AdminClients.addservice_addon.module_heading'] = 'Options %1$s';
$lang['AdminClients.addservice_addon.basic_heading'] = 'Options de base';
$lang['AdminClients.addservice_addon.field_term'] = 'Durée';
$lang['AdminClients.addservice_confirm.field_invoice_method'] = 'Méthode de facturation :';
$lang['AdminClients.addservice_confirm.field_invoice_method_create'] = 'Créer une facture';
$lang['AdminClients.addservice_confirm.field_invoice_method_append'] = 'Ajouter à la facture %1$s';
$lang['AdminClients.addservice_confirm.field_invoice_method_none'] = 'Ne pas facturer';
$lang['AdminClients.addservice_confirm.field_notify_order'] = 'Envoyer l\'e-mail de confirmation de la commande :';
$lang['AdminClients.addservice_confirm.field_notify_order_true'] = 'Oui';
$lang['AdminClients.addservice_confirm.field_notify_order_false'] = 'Non';
$lang['AdminClients.addservice_confirm.field_status'] = 'Statut :';
$lang['AdminClients.addservice_confirm.description'] = 'Description';
$lang['AdminClients.addservice_confirm.qty'] = 'Quantité';
$lang['AdminClients.addservice_confirm.price'] = 'Prix';
$lang['AdminClients.addservice_confirm.subtotal'] = 'Sous-total :';
$lang['AdminClients.addservice_confirm.setup_fee'] = 'Frais de mise en place :';
$lang['AdminClients.addservice_confirm.discount'] = 'Remise :';
$lang['AdminClients.addservice_confirm.field_coupon_code'] = 'Code des coupons';
$lang['AdminClients.addservice_confirm.field_update_coupon'] = 'Mise à jour';
$lang['AdminClients.addservice_confirm.field_add'] = 'Ajouter un service';
$lang['AdminClients.addservice_confirm.field_edit'] = 'Editer';
$lang['AdminClients.editservice.page_title'] = 'Client #%1$s Gérer le service';
$lang['AdminClients.editservice.boxtitle_editservice'] = 'Gérer le service : %1$s - %2$s';
$lang['AdminClients.editservice.tab_basic'] = 'Options de base';
$lang['AdminClients.editservice.tab_addon'] = 'Compléments (%1$s)';
$lang['AdminClients.editservice.suspension_reason_note'] = 'Motif de la suspension : %1$s';
$lang['AdminClients.editservice.cancellation_reason_note'] = 'Motif de l\'annulation : %1$s';
$lang['AdminClients.editservice.service_heading'] = 'Informations sur les services';
$lang['AdminClients.editservice.text_package_name'] = 'Nom de l\'emballage :';
$lang['AdminClients.editservice.text_label'] = 'Étiquette :';
$lang['AdminClients.editservice.text_qty'] = 'Quantité :';
$lang['AdminClients.editservice.text_term'] = 'Durée :';
$lang['AdminClients.editservice.text_status'] = 'Statut :';
$lang['AdminClients.editservice.text_date_added'] = 'Date de création :';
$lang['AdminClients.editservice.text_date_renews'] = 'Date de renouvellement :';
$lang['AdminClients.editservice.text_date_suspended'] = 'Date de suspension :';
$lang['AdminClients.editservice.text_date_canceled'] = 'Date d\'annulation prévue :';
$lang['AdminClients.editservice.text_recurring_coupon'] = 'Coupon récurrent :';
$lang['AdminClients.editservice.text_coupon_percent'] = '%1$s (%2$s%%)';
$lang['AdminClients.editservice.text_coupon_amount'] = '%1$s (%2$s)';
$lang['AdminClients.editservice.text_renewal_price'] = 'Prix de renouvellement :';
$lang['AdminClients.editservice.text_no_addons'] = 'Il n\'y a pas de modules complémentaires disponibles.';
$lang['AdminClients.editservice.text_children'] = 'Ce service est associé à un ou plusieurs services enfants. En annulant ce service, tous les services enfants seront également annulés.';
$lang['AdminClients.editservice.action_heading'] = 'Actions';
$lang['AdminClients.editservice.package_heading'] = 'Mise à niveau/rétrogradation';
$lang['AdminClients.editservice.module_heading'] = 'Options %1$s';
$lang['AdminClients.editservice.addon_heading'] = 'Compléments disponibles';
$lang['AdminClients.editservice.field_prorate'] = 'Taux';
$lang['AdminClients.editservice.tooltip_prorate'] = 'En cas de mise à niveau, une facture sera générée pour couvrir la différence entre le prix actuel et le nouveau prix. Toutefois, le calcul au prorata ne peut avoir lieu si un prix prioritaire est défini.';
$lang['AdminClients.editservice.tooltip_prorate_renewal'] = 'Une facture sera générée pour couvrir la différence de prix entre la date de renouvellement actuelle et la nouvelle date de renouvellement.';
$lang['AdminClients.editservice.field_use_module'] = 'Module d\'utilisation';
$lang['AdminClients.editservice.field_notify_order'] = 'Envoyer le courriel de confirmation de la commande';
$lang['AdminClients.editservice.field_module_save'] = 'Économiser';
$lang['AdminClients.editservice.field_module_activate'] = 'Activer';
$lang['AdminClients.editservice.field_add_addon'] = 'Ajouter un service';
$lang['AdminClients.editservice.action.field_action'] = 'Action';
$lang['AdminClients.editservice.action.field_notify_cancel'] = 'Envoi d\'un courriel d\'annulation de service';
$lang['AdminClients.editservice.action.field_cancel_term'] = 'Fin de la période';
$lang['AdminClients.editservice.action.field_cancel_term_date'] = 'Fin du mandat (%1$s)';
$lang['AdminClients.editservice.action.field_cancel_date'] = 'Date précise';
$lang['AdminClients.editservice.action.field_cancel_none'] = 'Ne pas annuler';
$lang['AdminClients.editservice.action.field_date_renews'] = 'Date Renouvellement';
$lang['AdminClients.editservice.action.field_suspension_reason'] = 'Motif de la suspension';
$lang['AdminClients.editservice.action.field_cancellation_reason'] = 'Motif de l\'annulation';
$lang['AdminClients.editservice.action.field_coupon_code'] = 'Code des coupons';
$lang['AdminClients.editservice.package.field_pricing'] = 'Paquet/Terme';
$lang['AdminClients.editservice.field_price_override'] = 'Prix dérogatoire';
$lang['AdminClients.editservice.field_override_price'] = 'Prix';
$lang['AdminClients.editservice.field_current_coupon_code'] = 'Code de réduction actuel';
$lang['AdminClients.editservice.field_new_coupon_code'] = 'Nouveau code de coupon';
$lang['AdminClients.editservice.tooltip_coupon_code'] = 'Le coupon doit être valide et sera appliqué lors du renouvellement du service.';
$lang['AdminClients.serviceinfo.no_results'] = 'Ce service n\'est pas détaillé.';
$lang['AdminClients.serviceinfo.cancellation_reason'] = 'Motif de l\'annulation : %1$s';
$lang['AdminClients.makepayment.page_title'] = 'Le client #%1$s effectue le paiement';
$lang['AdminClients.makepayment.boxtitle_makepayment'] = 'Effectuer le paiement';
$lang['AdminClients.makepayment.heading_paymentaccount'] = 'Financement';
$lang['AdminClients.makepayment.field_paymentaccount'] = '%1$s %2$s - %3$s x%4$s';
$lang['AdminClients.makepayment.field_paymentaccount_autodebit'] = '(débit automatique) %1$s %2$s - %3$s x%4$s';
$lang['AdminClients.makepayment.field_paymentaccount_ach'] = 'Comptes ACH';
$lang['AdminClients.makepayment.field_paymentaccount_cc'] = 'Comptes de cartes de crédit';
$lang['AdminClients.makepayment.field_submit'] = 'Continuer';
$lang['AdminClients.makepayment.field_useaccount'] = 'Utiliser le compte de paiement';
$lang['AdminClients.makepayment.field_newdetails'] = 'Nouveaux détails de paiement';
$lang['AdminClients.makepayment.boxtitle_makepaymentamount'] = 'Effectuer le paiement';
$lang['AdminClients.makepayment.record_invoice'] = 'Enregistrer le paiement pour la facture #%1$s, au lieu de';
$lang['AdminClients.makepayment.record_payment'] = 'Enregistrer le paiement à la place';
$lang['AdminClients.makepaymentamount.heading_invoices'] = 'Sélection des factures';
$lang['AdminClients.makepaymentamount.field_submit'] = 'Réviser et confirmer';
$lang['AdminClients.makepaymentamount.field_receipt'] = 'Accusé de réception par courriel';
$lang['AdminClients.makepaymentamount.field_credit'] = 'Autre montant du paiement';
$lang['AdminClients.makepaymentamount.field_currency'] = 'Monnaie';
$lang['AdminClients.makepaymentamount.text_amount'] = 'Montant à payer';
$lang['AdminClients.makepaymentamount.text_due'] = 'Montant dû';
$lang['AdminClients.makepaymentamount.text_invoice'] = 'Facture #';
$lang['AdminClients.makepaymentamount.text_datedue'] = 'Date d\'échéance';
$lang['AdminClients.makepaymentamount.no_results'] = 'Il n\'y a pas de factures dans cette devise.';
$lang['AdminClients.makepaymentconfirm.boxtitle_makepaymentconfirm'] = 'Confirmer le paiement';
$lang['AdminClients.makepaymentconfirm.field_submit'] = 'Soumettre le paiement';
$lang['AdminClients.makepaymentconfirm.field_edit'] = 'Modifier le paiement';
$lang['AdminClients.makepaymentconfirm.text_amount'] = 'Montant à appliquer';
$lang['AdminClients.makepaymentconfirm.text_due'] = 'Montant dû';
$lang['AdminClients.makepaymentconfirm.text_invoice'] = 'Facture #';
$lang['AdminClients.makepaymentconfirm.text_datedue'] = 'Date d\'échéance';
$lang['AdminClients.makepaymentconfirm.account_info'] = '%1$s (%2$s) se terminant par %3$s';
$lang['AdminClients.makepaymentconfirm.account_info_type'] = '%1$s';
$lang['AdminClients.makepaymentconfirm.account_exp'] = 'expire %1$s';
$lang['AdminClients.makepaymentconfirm.total'] = 'Total :';
$lang['AdminClients.makepaymentconfirm.payment_details'] = 'Modalités de paiement';
$lang['AdminClients.makepaymentconfirm.email_receipt'] = 'Accusé de réception par courriel';
$lang['AdminClients.makepaymentconfirm.email_receipt_yes'] = 'Oui';
$lang['AdminClients.makepaymentconfirm.email_receipt_no'] = 'Non';
$lang['AdminClients.recordpaymentconfirm.trans_info_credit'] = 'Demande de crédit';
$lang['AdminClients.makepaymentconfirm.trans_info_detailed'] = '%1$s Paiement #%2$s';
$lang['AdminClients.makepaymentconfirm.trans_info'] = '%1$s Paiement';
$lang['AdminClients.recordpayment.page_title'] = 'Client #%1$s Record Payment';
$lang['AdminClients.recordpayment.boxtitle_recordpayment'] = 'Enregistrement du paiement';
$lang['AdminClients.recordpayment.field_receipt'] = 'Accusé de réception par courriel';
$lang['AdminClients.recordpayment.field_amount'] = 'Montant du paiement';
$lang['AdminClients.recordpayment.field_payment_type_record'] = 'Enregistrer un nouveau paiement';
$lang['AdminClients.recordpayment.field_payment_type_credit'] = 'Demande de crédit (%1$s)';
$lang['AdminClients.recordpayment.field_currency'] = 'Monnaie';
$lang['AdminClients.recordpayment.field_status'] = 'Statut';
$lang['AdminClients.recordpayment.field_datereceived'] = 'Date de réception';
$lang['AdminClients.recordpayment.field_transaction_id'] = 'Numéro de chèque/identification';
$lang['AdminClients.recordpayment.field_transactiontype'] = 'Type de paiement';
$lang['AdminClients.recordpayment.field_gateway_id'] = 'Passerelle de paiement';
$lang['AdminClients.recordpayment.field_submit'] = 'Continuer';
$lang['AdminClients.recordpayment.text_datereceived'] = 'Fixer la date de réception';
$lang['AdminClients.recordpayment.gateway_none'] = 'Aucun';
$lang['AdminClients.recordpaymentconfirm.boxtitle_recordconfirm'] = 'Confirmer le paiement';
$lang['AdminClients.recordpaymentconfirm.total'] = 'Total :';
$lang['AdminClients.recordpaymentconfirm.payment_details'] = 'Modalités de paiement';
$lang['AdminClients.recordpaymentconfirm.email_receipt'] = 'Accusé de réception par courriel';
$lang['AdminClients.recordpaymentconfirm.email_receipt_yes'] = 'Oui';
$lang['AdminClients.recordpaymentconfirm.email_receipt_no'] = 'Non';
$lang['AdminClients.recordpaymentconfirm.trans_info_detailed'] = '%1$s Paiement #%2$s';
$lang['AdminClients.recordpaymentconfirm.trans_info'] = '%1$s Paiement';
$lang['AdminClients.recordpaymentconfirm.field_submit'] = 'Soumettre le paiement';
$lang['AdminClients.recordpaymentconfirm.field_edit'] = 'Modifier le paiement';
$lang['AdminClients.setcontactview.text_none'] = 'Aucun';
$lang['AdminClients.services.page_title'] = 'Services du client #%1';
$lang['AdminClients.services.boxtitle_services'] = 'Services';
$lang['AdminClients.services.heading_addons'] = 'Compléments';
$lang['AdminClients.services.heading_status'] = 'Statut';
$lang['AdminClients.services.heading_package'] = 'Paquet';
$lang['AdminClients.services.heading_label'] = 'Étiquette';
$lang['AdminClients.services.heading_term'] = 'Durée';
$lang['AdminClients.services.heading_datecreated'] = 'Date de création';
$lang['AdminClients.services.heading_daterenews'] = 'Date Renouvellement';
$lang['AdminClients.services.heading_datesuspended'] = 'Date de suspension';
$lang['AdminClients.services.heading_datecanceled'] = 'Date d\'annulation';
$lang['AdminClients.services.heading_options'] = 'Options';
$lang['AdminClients.services.category_active'] = 'Actif';
$lang['AdminClients.services.category_pending'] = 'En attente';
$lang['AdminClients.services.category_suspended'] = 'Suspendu';
$lang['AdminClients.services.category_canceled'] = 'Annulé';
$lang['AdminClients.services.categorylink_newservice'] = 'Nouveau service';
$lang['AdminClients.services.recurring_term'] = '%1$s %2$s @ %3$s';
$lang['AdminClients.services.option_manage'] = 'Gérer';
$lang['AdminClients.services.option_delete'] = 'Supprimer';
$lang['AdminClients.services.confirm_delete'] = 'Êtes-vous sûr de vouloir supprimer ce service ?';
$lang['AdminClients.services.no_results'] = 'Il n\'y a pas de services ayant ce statut.';
$lang['AdminClients.services.text_never'] = 'Jamais';
$lang['AdminClients.services.action.schedule_cancellation'] = 'Annulation du calendrier';
$lang['AdminClients.services.action.invoice_renewal'] = 'Renouvellement de la facture';
$lang['AdminClients.services.action.push_to_client'] = 'Pousser vers le client';
$lang['AdminClients.services.action.field_action_type_term'] = 'Fin de la période';
$lang['AdminClients.services.action.field_action_type_date'] = 'Date précise';
$lang['AdminClients.services.action.field_action_type_none'] = 'Ne pas annuler';
$lang['AdminClients.services.action.field_cycles'] = 'Nombre de cycles';
$lang['AdminClients.services.action.field_client'] = 'Client :';
$lang['AdminClients.services.field_actionsubmit'] = 'Soumettre';
$lang['AdminClients.transactions.page_title'] = 'Client #%1$s Transactions';
$lang['AdminClients.transactions.boxtitle_transactions'] = 'Transactions';
$lang['AdminClients.transactions.heading_type'] = 'Type';
$lang['AdminClients.transactions.heading_amount'] = 'Montant';
$lang['AdminClients.transactions.heading_credited'] = 'Crédité';
$lang['AdminClients.transactions.heading_applied'] = 'Appliqué';
$lang['AdminClients.transactions.heading_number'] = 'Nombre';
$lang['AdminClients.transactions.heading_reference_id'] = 'Référence #';
$lang['AdminClients.transactions.heading_date'] = 'Date';
$lang['AdminClients.transactions.heading_options'] = 'Options';
$lang['AdminClients.transactions.headingexpand_invoice'] = 'Facture';
$lang['AdminClients.transactions.headingexpand_amount'] = 'Montant';
$lang['AdminClients.transactions.headingexpand_appliedon'] = 'Appliqué le';
$lang['AdminClients.transactions.headingexpand_options'] = 'Options';
$lang['AdminClients.transactions.category_approved'] = 'Approuvé';
$lang['AdminClients.transactions.category_declined'] = 'Refusé';
$lang['AdminClients.transactions.category_voided'] = 'Annulé';
$lang['AdminClients.transactions.category_error'] = 'Erreur';
$lang['AdminClients.transactions.category_pending'] = 'En attente';
$lang['AdminClients.transactions.category_refunded'] = 'Remboursé';
$lang['AdminClients.transactions.category_returned'] = 'Renvoyé';
$lang['AdminClients.transactions.categorylink_payment'] = 'Effectuer le paiement';
$lang['AdminClients.transactions.option_edit'] = 'Editer';
$lang['AdminClients.transactions.no_results'] = 'Il n\'y a pas de transactions avec ce statut.';
$lang['AdminClients.transactions.applied_no_results'] = 'Cette transaction n\'a été appliquée à aucune facture.';
$lang['AdminClients.view.page_title'] = 'Profil du client #%1$s';
$lang['AdminClients.view.boxtitle_client'] = 'Client #%1$s';
$lang['AdminClients.view.boxtitle_contacts'] = 'Contacts';
$lang['AdminClients.view.status_link'] = '(Cliquez pour changer)';
$lang['AdminClients.view.number'] = '(%1$s %2$s)';
$lang['AdminClients.view.link_vcard'] = 'vCard';
$lang['AdminClients.view.link_notes'] = 'Notes';
$lang['AdminClients.view.link_editclient'] = 'Editer';
$lang['AdminClients.view.setting_memberof'] = 'Membre de';
$lang['AdminClients.view.setting_invoicemethod'] = 'Méthode de facturation';
$lang['AdminClients.view.setting_autodebit'] = 'Débit automatique';
$lang['AdminClients.view.setting_autosuspension'] = 'Suspension automobile';
$lang['AdminClients.view.setting_email_verification'] = 'Vérification de l\'adresse électronique';
$lang['AdminClients.view.setting_sublogin'] = 'Sous-connexion';
$lang['AdminClients.view.setting_send_payment_notices'] = 'Avis de paiement';
$lang['AdminClients.view.setting_enabled'] = 'Activé';
$lang['AdminClients.view.setting_disabled'] = 'Handicapés';
$lang['AdminClients.view.setting_verified'] = 'Vérifié';
$lang['AdminClients.view.setting_unverified'] = 'Non vérifié';
$lang['AdminClients.view.setting_unsent'] = 'Sans objet';
$lang['AdminClients.view.member_since'] = 'Membre depuis %1$s';
$lang['AdminClients.view.member_last_seen'] = 'Dernière visite de %1$s à partir de';
$lang['AdminClients.view.member_last_seen_never'] = 'La dernière fois qu\'on l\'a vue, c\'était pour la première fois.';
$lang['AdminClients.view.tooltip_activity'] = 'Dernière activité';
$lang['AdminClients.view.tooltip_location'] = 'Localisation';
$lang['AdminClients.view.tooltip_last_activity_now'] = 'En ce moment même';
$lang['AdminClients.view.tooltip_last_activity_minute'] = 'il y a 1 minute';
$lang['AdminClients.view.tooltip_last_activity_minutes'] = 'Il y a %1$s minutes';
$lang['AdminClients.view.tooltip_autodebit_enabled'] = 'Le débit automatique est activé, mais aucun compte de paiement n\'est sélectionné pour le débit automatique. Un compte de paiement doit être sélectionné pour que les frais soient prélevés automatiquement.';
$lang['AdminClients.view.delaysuspension_modal_title'] = 'Suspension à retardement';
$lang['AdminClients.view.actions_title'] = 'Actions sur le compte';
$lang['AdminClients.view.actionlink_createinvoice'] = 'Créer une facture';
$lang['AdminClients.view.actionlink_addservice'] = 'Ajouter un service';
$lang['AdminClients.view.actionlink_addcontact'] = 'Ajouter un contact';
$lang['AdminClients.view.actionlink_makepayment'] = 'Effectuer le paiement';
$lang['AdminClients.view.actionlink_recordpayment'] = 'Enregistrement du paiement';
$lang['AdminClients.view.actionlink_manageaccount'] = 'Comptes de paiement';
$lang['AdminClients.view.actionlink_addnote'] = 'Ajouter une note';
$lang['AdminClients.view.actionlink_setpackages'] = 'Paquets d\'ensembles';
$lang['AdminClients.view.actionlink_passwordreset'] = 'Envoyer la réinitialisation du mot de passe';
$lang['AdminClients.view.actionlink_viewmaillog'] = 'Afficher le journal des courriers';
$lang['AdminClients.view.actionlink_mergeclient'] = 'Fusionner le client';
$lang['AdminClients.view.actionlink_deleteclient'] = 'Supprimer le client';
$lang['AdminClients.view.actionlink_emailclient'] = 'Client de messagerie';
$lang['AdminClients.view.actionlink_login'] = 'Se connecter en tant que client';
$lang['AdminClients.view.actionlink_more'] = 'Afficher toutes les actions';
$lang['AdminClients.view.actionlink_less'] = 'Afficher les actions communes';
$lang['AdminClients.view.confirm_delete'] = 'Êtes-vous sûr de vouloir supprimer ce client ?';
$lang['AdminClients.view.contact_type'] = '(%1$s)';
$lang['AdminClients.getcurrencyamounts.text_total_credits'] = 'Total des crédits';
$lang['AdminClients.getcurrencyamounts.text_total_due'] = 'Total dû';
$lang['AdminClients.showcard.modal_title'] = 'Afficher la carte';
$lang['AdminClients.showcard.field_passphrase'] = 'Phrase de passe';
$lang['AdminClients.showcard.field_staff_password'] = 'Votre mot de passe de connexion';
$lang['AdminClients.showcard.field_submit'] = 'Soumettre';
$lang['AdminClients.showcard.!error.passphrase'] = 'La phrase d\'authentification n\'est pas valide.';
$lang['AdminClients.showcard.!error.password'] = 'Le mot de passe n\'est pas valide.';
$lang['AdminClients.showaccount.modal_title'] = 'Afficher le compte';
$lang['AdminClients.showaccount.field_passphrase'] = 'Phrase de passe';
$lang['AdminClients.showaccount.field_staff_password'] = 'Votre mot de passe de connexion';
$lang['AdminClients.showaccount.field_submit'] = 'Soumettre';
$lang['AdminClients.showaccount.!error.passphrase'] = 'La phrase d\'authentification n\'est pas valide.';
$lang['AdminClients.showaccount.!error.password'] = 'Le mot de passe n\'est pas valide.';
$lang['AdminClients.packages.page_title'] = 'Client #%1$s Paquets restreints';
$lang['AdminClients.packages.boxtitle_packages'] = 'Paquets restreints';
$lang['AdminClients.packages.text_name'] = 'Nom';
$lang['AdminClients.packages.text_module'] = 'Module';
$lang['AdminClients.packages.field_packagesubmit'] = 'Sauvegarder l\'accès restreint au paquet';
$lang['AdminClients.packages.no_results'] = 'Il n\'y a pas de paquets restreints.';
$lang['AdminClients.delaysuspension.field_autosuspend_date'] = 'Date de report de la suspension jusqu\'au';
$lang['AdminClients.delaysuspension.text_clear'] = 'Clair';
$lang['AdminClients.delaysuspension.field_save'] = 'Économiser';
$lang['AdminClients.delete.field_password'] = 'Saisissez votre mot de passe de connexion pour confirmer';
$lang['AdminClients.delete.field_submit'] = 'Supprimer';
$lang['AdminClients.!success.invoice_split'] = 'La facture #%1$s a été scindée avec succès en facture #%2$s.';
$lang['AdminClients.!success.services_resent'] = 'L\'e-mail de bienvenue pour les services sélectionnés a été généré avec succès.';
$lang['AdminClients.add.field_recovery_email'] = 'Courriel de récupération (facultatif)';
$lang['AdminClients.addcontact.field_recovery_email'] = 'Courriel de récupération (facultatif)';
$lang['AdminClients.edit.field_recovery_email'] = 'Courriel de récupération (facultatif)';
$lang['AdminClients.editcontact.field_recovery_email'] = 'Courriel de récupération (facultatif)';
$lang['AdminClients.editinvoice.heading_split'] = 'Séparer';
$lang['AdminClients.editinvoice.field_invoicesplit'] = 'Facture fractionnée';
$lang['AdminClients.editinvoice.confirm_split'] = 'Êtes-vous sûr de diviser la facture ?';
$lang['AdminClients.editservice.text_date_last_renewed'] = 'Date du dernier renouvellement :';
$lang['AdminClients.services.action.resend_welcome_email'] = 'Renvoi de l\'e-mail de bienvenue';

